// Triangle.h
// Definit la description d'un triangle pour le moteur 3D : un index par vertex


#ifndef V3D_BASICS_TRIANGLE_H_INCLUDED
#define V3D_BASICS_TRIANGLE_H_INCLUDED

namespace V3D {


class Triangle
{
public:
	// ATTENTION : Pas de virtuel dans la classe. Ne doit pas etre derivee.
	Triangle() {}
	inline Triangle( uint32 _a, uint32 _b, uint32 _c);
	
	inline void Set( uint32 _a, uint32 _b, uint32 _c);

	inline bool HasVertex( uint32 nVtxIndex) const;


public:
	uint32	a;  // index du vertex a
	uint32	b;  // index du vertex b
	uint32	c;  // index du vertex c
};


typedef std::vector<Triangle> TriangleArray;



//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

inline Triangle::Triangle( uint32 _a, uint32 _b, uint32 _c)
	: a(_a), b(_b), c(_c) 
{}


inline void Triangle::Set( uint32 _a, uint32 _b, uint32 _c)
{
	a = _a;
	b = _b;
	c = _c;
}

inline bool Triangle::HasVertex( uint32 nVtxIndex) const
{
	return (nVtxIndex == a) || (nVtxIndex == b) || (nVtxIndex == c);
}


} // namespaces


#endif	// #ifndef V3D_BASICS_TRIANGLE_H_INCLUDED
